// -*- mode: c++ -*-

#include <string>
#include <chrono>
#include <stdexcept>

static const char* dateFmt = "%Y%m%d";

struct decoded_address {
  std::string username;
  std::string domain;
  std::string sdate;
  std::chrono::system_clock::time_point date;
  bool date_valid() const {
    return date >= std::chrono::system_clock::now();
  }
  std::string address() const {
    return username + "@" + domain;
  }
};

enum encode_method {
  base_32,
  base_58
};

extern encode_method gEncode;

void test_crypto();
void init_crypto(const std::string& key = "");
std::string generate_address(const std::string& username, const std::string&date
                             #if MAYBE_FIXED_IV
                             , bool aNoRandomIv
                             #endif
  );
std::string generate_address(const std::string& username,
                             const std::chrono::system_clock::time_point& date
                             #if MAYBE_FIXED_IV
                             , bool aNoRandomIv = false
                             #endif
  );
inline std::string generate_address(const std::string& username, int days) {
  return generate_address(username, std::chrono::system_clock::now() +
                          std::chrono::hours(days * 24));
}
decoded_address decode(const std::string& address);

inline static std::string date2s(const std::chrono::system_clock::time_point& date) {
  std::time_t t = std::chrono::system_clock::to_time_t(date);
  char s[12];
  if (!std::strftime(s, sizeof(s), dateFmt, std::localtime(&t)))
    throw std::runtime_error{"Cannot convert date to string"};
  return s;
}
