#include <string>
#include <iostream>
#include <thread>
#include <algorithm>
#include <sys/stat.h>

#include "crypto.h"
#include "netstring.h"
#include "unixserverstream.hpp"
#include "unixclientstream.hpp"
#include "exception.hpp"

static char buffer[100001];
extern bool gDebug;
extern bool gLowercase;
#if defined MAYBE_FIXED_IV
extern bool gNoRandomIv;
#endif

extern std::string _generate(const std::string& mail, int days = 3);
extern std::string _generate_noiv(const std::string& mail, int days = 3);

void serve(const std::string& sockname) {
  try {
    libsocket::unix_stream_server srv(sockname);
    do {
      std::unique_ptr<libsocket::unix_stream_client> client;
      client = srv.accept2();
      ssize_t len = client->rcv(buffer, sizeof(buffer) - 1);
      buffer[len] = 0;
      if (gDebug) std::cerr << "< " << buffer << std::endl;
      try {
        std::string cmd = from_netstring(buffer);
        if (gDebug) std::cerr << "< " << cmd << std::endl;
        if (cmd.compare(0, 5, "mail ") != 0) {
          if (gDebug) std::cerr << "> PERM this table only handles mail"
                                << std::endl;
          *client << to_netstring( "PERM this table only handles mail");
        }
        cmd.erase(0, 5);
        decoded_address addr = decode(cmd);
        if (addr.date_valid()) {
        if (gDebug) std::cerr << "> OK " << addr.address() << std::endl;
          *client << to_netstring("OK " + addr.address());
        }
        else {
          if (gDebug) std::cerr << "> NOTFOUND expired address: "
                                << addr.address() << ": "
                                << addr.sdate << std::endl;
          *client << to_netstring("NOTFOUND ");
        }
      } catch (const netstring_exception& ex) {
        if (gDebug) std::cerr << "> PERM " << ex.what() << std::endl;
        *client << to_netstring(std::string("PERM ") + ex.what());
      } catch (const std::exception& ex) {
        if (gDebug) std::cerr << "> NOTFOUND " << ex.what() << std::endl;
        *client << to_netstring("NOTFOUND ");
      }
    } while (true);
  }
  catch (const libsocket::socket_exception& exc)
  {
    std::cerr << "[" << sockname << "]: " << exc.mesg << std::endl;
  }
}

struct {
  std::thread th;
  std::string sockname;
} gGenThread;

static void _serve_gen() {
  try {
    libsocket::unix_stream_server srv(gGenThread.sockname);
    chmod(gGenThread.sockname.c_str(),
          S_IRUSR|S_IWUSR|S_IRGRP|S_IWGRP|S_IROTH|S_IWOTH);
    do {
      std::unique_ptr<libsocket::unix_stream_client> client;
      client = srv.accept2();
      ssize_t len = client->rcv(buffer, sizeof(buffer) - 1);
      buffer[len] = 0;
      if (gDebug) std::cerr << "< " << buffer << std::endl;
      try {
        #if defined MAYBE_FIXED_IV
        bool lNoIv = false;
        #endif
        std::string cmd = from_netstring(buffer);
        if (gDebug) std::cerr << "< " << cmd << std::endl;
        auto posc = cmd.find(':');
        if (posc != std::string::npos) {
          std::string flag = cmd.substr(0, posc);
          cmd = cmd.substr(posc + 1);
          #if defined MAYBE_FIXED_IV
          lNoIv = flag.find("noiv") != std::string::npos;
          #endif
        }
        auto pos = cmd.find(' ');
        if (pos == std::string::npos) {
          #if defined MAYBE_FIXED_IV
          std::string res = lNoIv ? _generate_noiv(cmd) : _generate(cmd);
          #else
          std::string res = _generate(cmd);
          #endif
          if (gDebug) std::cerr << "> OK " << res << std::endl;
          *client << to_netstring(std::string("OK ") + res);
        }
        else {
          const int exp = std::atoi(cmd.substr(pos + 1).c_str());
          #if defined MAYBE_FIXED_IV
          std::string res = lNoIv ? _generate_noiv(cmd, exp) :
            _generate(cmd.substr(0, pos), exp);
          #else
          std::string res = _generate(cmd.substr(0, pos), exp);
          #endif
          if (gDebug) std::cerr << "> OK " << res << std::endl;
          *client << to_netstring(std::string("OK ") + res);
        }
      } catch (const std::exception& ex) {
        if (gDebug) std::cerr << "> ERROR " << ex.what() << std::endl;
        *client << to_netstring(std::string("ERROR ") + ex.what());
      }
    } while (true);
  }
  catch (const libsocket::socket_exception& exc)
  {
    std::cerr << "[" << gGenThread.sockname << "]: " << exc.mesg << std::endl;
  }
}

void serve_gen(const std::string& sockname) {
  gGenThread.sockname = sockname;
  std::thread th(_serve_gen);
  std::swap(gGenThread.th, th);
}

int generate_connect(const std::string& sockname, const std::string& mail,
                     int days) {
  try {
    libsocket::unix_stream_client client{sockname};
    std::string _cmd = (days != 3) ? mail + " " + std::to_string(days) : mail;
    #if defined MAYBE_FIXED_IV
    if (gNoRandomIv)
      _cmd = "noiv:" + _cmd;
    #endif
    std::string cmd = to_netstring(_cmd);
    if (gDebug) std::cerr << "> " << cmd << std::endl;
    client << cmd;
    ssize_t len = client.rcv(buffer, sizeof(buffer) - 1);
    buffer[len] = 0;
    cmd = from_netstring(buffer);
    if (gDebug) std::cerr << "< " << cmd << std::endl;
    if (cmd.compare(0, 3, "OK ") != 0) {
      std::cerr << "Invalid response: " << cmd << std::endl;
      return EXIT_FAILURE;
    }
    cmd.erase(0, 3);
    if (gLowercase)
      std::transform(cmd.begin(), cmd.end(), cmd.begin(), ::tolower);
    std::cout << cmd << std::endl;
  }
  catch (const libsocket::socket_exception& exc)
  {
    std::cerr << "[" << gGenThread.sockname << "]: " << exc.mesg << std::endl;
    return EXIT_FAILURE;
  }
  return EXIT_SUCCESS;
}
