#include "netstring.h"

std::string to_netstring(const std::string& s) {
  if (s.length() == 0)
    return "0:,";
  else
    return std::to_string(s.length()) + ":" + s + ",";
}

std::string from_netstring(const std::string& ns) {
  if (ns.size() < 3)
    throw netstring_exception{"invalid netstring: string too short"};
  auto pos = ns.find(':');
  if (pos == std::string::npos)
    throw netstring_exception{"invalid netstring: no semicolon"};
  std::string digits = ns.substr(0, pos);
  size_t len = std::stoul(digits);
  if (digits != std::to_string(len))
    throw netstring_exception{"invalid netstring: cannot parse size"};
  std::string cmd = ns.substr(pos + 1);
  if (cmd.empty())
    throw netstring_exception{"invalid netstring: empty command"};
  if (cmd.back() == ',')
    cmd.pop_back();
  if (cmd.size() != len)
    throw netstring_exception{"invalid netstring: invalid size"};
  return cmd;
}
