/*
	Rolistik - logiciel collaboratif d'aide aux jeux de roles en ligne
	Copyright (C) 2007 - Romain Campioni  Tous droits rservs.

	Ce programme est un logiciel libre ; vous pouvez le redistribuer ou le
	modifier suivant les termes de la GNU General Public License telle que
	publie par la Free Software Foundation : soit la version 2 de cette
	licence, soit ( votre gr) toute version ultrieure.

	Ce programme est distribu dans lespoir quil vous sera utile, mais SANS
	AUCUNE GARANTIE : sans mme la garantie implicite de COMMERCIALISABILIT
	ni dADQUATION  UN OBJECTIF PARTICULIER. Consultez la Licence Gnrale
	Publique GNU pour plus de dtails.

	Vous devriez avoir reu une copie de la Licence Gnrale Publique GNU avec
	ce programme ; si ce nest pas le cas, consultez :
	<http://www.gnu.org/licenses/old-licenses/gpl-2.0.html>

	Par ailleurs ce logiciel est gratuit et ne peut en aucun cas tre
	commercialis, conformment  la "FMOD Non-Commercial License".
*/


	#include <QtGui>

	#include "TextEditAmeliore.h"


	/********************************************************************/
	/* Constructeur                                                     */
	/********************************************************************/	
    TextEditAmeliore::TextEditAmeliore(QWidget *parent)
        : QTextEdit(parent)
    {
	}
	
	/********************************************************************/	
	/* Verifie si l'utilisateur a appuye sur la touche Entree. Si oui   */
	/* le signal entreePressee est emis                                 */
	/********************************************************************/	
	void TextEditAmeliore::keyPressEvent(QKeyEvent *e)
	{
		// On recupere la touche qui vient d'etre enfoncee
		int touche = e->key();
		
		// S'il s'agit de la touche Entree ou Return, on emet le signal entreePressee
		if (touche == Qt::Key_Return || touche == Qt::Key_Enter)
			emit entreePressee();

		// S'il s'agit de la touche fleche haut, on emet le signal hautPressee
		else if (touche == Qt::Key_Up)
			emit hautPressee();

		// S'il s'agit de la touche fleche bas, on emet le signal basPressee
		else if (touche == Qt::Key_Down)
			emit basPressee();

		// Sinon on passe l'evenement au QTextEdit
		else
			QTextEdit::keyPressEvent(e);
	}
